﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RevisionAnalyser.Global;
using SharpSvn;
using System.Collections.ObjectModel;

namespace RevisionAnalyser.Projects.RecoderProject.Tasks
{
    public class TimelineSubTask : Task
    {
        private RecoderProject _project = (RecoderProject)CurrentProject.Instance.Project;
        private int _rev;
        private SvnClient _client;

        public TimelineSubTask(SvnClient client, int rev)
        {
            _client = client;
            _rev = rev;
        }

        public override void Run()
        {
            AddLog(String.Format("Fetching log information for revision {0}...", _rev), Constants.COLOR_GREEN);
            
            SvnLogArgs args = new SvnLogArgs();
            Collection<SvnLogEventArgs> logItems;
            args.RetrieveAllProperties = false;
            args.RetrieveChangedPaths = false;
            args.RetrieveMergedRevisions = false;
            args.Range = new SvnRevisionRange(_rev, _rev);
            args.SvnError += new EventHandler<SvnErrorEventArgs>(args_SvnError);
            args.Limit = 1;
            try
            {
                _client.GetLog(new Uri(_project.SvnUrl), args, out logItems);
                if (logItems.Count == 1)
                {
                    SvnLogEventArgs item = logItems[0];
                    AddLog(String.Format("Revision: {0}", item.Revision), Constants.COLOR_GREEN);
                    AddLog(String.Format("Author: {0}", item.Author), Constants.COLOR_GREEN);
                    AddLog(String.Format("Time: {0}", item.Time.ToString()), Constants.COLOR_GREEN);
                    AddLog(String.Format("Log Message: {0}", item.LogMessage), Constants.COLOR_GREEN);
                }
                else
                {
                    AddLog("Failed to fetch log information", Constants.COLOR_RED);
                }
            }
            catch (Exception ex)
            {
                AddLog(ex.Message, Constants.COLOR_RED);
            }
            TaskFinished();
        }

        void args_SvnError(object sender, SvnErrorEventArgs e)
        {
            e.Cancel = false;
        }
    }
}
